﻿$oemfiles = Get-ChildItem -Path "$ENV:windir\inf" -Filter "*.inf" -Recurse
$log = [System.Collections.Generic.List[PSObject]]::new()

$oemfiles | ForEach-Object {
    $content = Get-Content $_.FullName -Raw
    if($content -match "CatalogFile\s*=\s*(e2fn|e2f|e2f68)\.cat" -and $content -match "Provider\s*=\s*%Intel%") {
        $logEntry = [PSCustomObject]@{
            'File' = $_.FullName
            'Date' = (Get-Date).ToString('yyyy/MM/dd HH:mm:ss')
            'Action' = 'Deleted'
        }
        $log.Add($logEntry)
        $proc = Start-Process -FilePath ".\devcon.exe" -ArgumentList "dp_delete", $_.FullName -PassThru
        $proc.WaitForExit()
    }
}

$log | Export-Csv -Path "$env:ProgramData\ASUS\LAN_log.csv" -Encoding UTF8 -NoTypeInformation -Append
